/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.FilteredTransporterType;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.proxy.client.render.TransporterTESR;
import com.buuz135.industrial.utils.FluidUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.TileUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TransporterFluidType
extends FilteredTransporterType<FluidStack, IFluidHandler> {
    public static final int QUEUE_SIZE = 6;
    private HashMap<Direction, List<FluidStack>> queue = new HashMap();

    public TransporterFluidType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
        for (Direction value : Direction.values()) {
            while (this.queue.computeIfAbsent(value, direction -> new ArrayList()).size() < 6) {
                this.queue.get(value).add(0, FluidStack.EMPTY);
            }
            if (this.queue.size() <= 6) continue;
            this.queue.get(value).remove(this.queue.get(value).size() - 1);
        }
    }

    @Override
    public RegulatorFilter<FluidStack, IFluidHandler> createFilter() {
        return new RegulatorFilter<FluidStack, IFluidHandler>(20, 20, 5, 3, 50, 250, 32000, "mb"){

            @Override
            public int matches(FluidStack stack, IFluidHandler iFluidHandler, boolean isRegulated) {
                int amount = 0;
                if (this.isEmpty()) {
                    return stack.getAmount();
                }
                if (isRegulated) {
                    for (int i = 0; i < iFluidHandler.getTanks(); ++i) {
                        if (!iFluidHandler.isFluidValid(i, stack) || !iFluidHandler.getFluidInTank(i).isFluidEqual(stack)) continue;
                        amount += iFluidHandler.getFluidInTank(i).getAmount();
                    }
                }
                for (IFilter.GhostSlot slot : this.getFilter()) {
                    FluidStack original = FluidUtil.getFluidContained((ItemStack)slot.getStack()).orElse(null);
                    if (original == null || !original.isFluidEqual(stack)) continue;
                    int allowedAmount = isRegulated ? slot.getAmount() : Integer.MAX_VALUE;
                    int returnAmount = Math.min(stack.getAmount(), allowedAmount - amount);
                    if (returnAmount <= 0) continue;
                    return returnAmount;
                }
                return 0;
            }
        };
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getSpeed();
        if (!this.getWorld().f_46443_ && (float)this.getWorld().m_46467_() % Math.max(1.0f, 4.0f - speed) == 0.0f) {
            IBlockContainer container = this.getContainer();
            if (this.getAction() == TransporterTypeFactory.TransporterAction.EXTRACT && container instanceof TransporterTile) {
                for (Direction direction : ((TransporterTile)container).getTransporterTypeMap().keySet()) {
                    TransporterType transporterType = ((TransporterTile)container).getTransporterTypeMap().get(direction);
                    if (!(transporterType instanceof TransporterFluidType) || transporterType.getAction() != TransporterTypeFactory.TransporterAction.INSERT) continue;
                    TileUtil.getTileEntity((BlockGetter)this.getWorld(), (BlockPos)this.getPos().m_142300_(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().m_122424_()).ifPresent(origin -> TileUtil.getTileEntity((BlockGetter)this.getWorld(), (BlockPos)this.getPos().m_142300_(direction)).ifPresent(otherTile -> otherTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).ifPresent(destination -> {
                        int simulatedInserted;
                        int amount = (int)(50.0f * this.getEfficiency());
                        FluidStack simulatedStack = origin.drain(amount, IFluidHandler.FluidAction.SIMULATE);
                        int filteredAmount = ((TransporterFluidType)transporterType).getFilter().matches(simulatedStack, (IFluidHandler)destination, ((TransporterFluidType)transporterType).isRegulated());
                        if (this.filter(this.getFilter(), this.isWhitelist(), simulatedStack, (IFluidHandler)origin, false) && filteredAmount > 0 && this.filter(((TransporterFluidType)transporterType).getFilter(), ((TransporterFluidType)transporterType).isWhitelist(), simulatedStack, (IFluidHandler)destination, ((TransporterFluidType)transporterType).isRegulated()) && (simulatedInserted = destination.fill(simulatedStack, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                            destination.fill(origin.drain(simulatedInserted, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                            ((TransporterFluidType)transporterType).addTransferedStack(this.getSide(), simulatedStack);
                        }
                    }))));
                }
            }
        }
    }

    private boolean filter(RegulatorFilter<FluidStack, IFluidHandler> filter, boolean whitelist, FluidStack fluidStack, IFluidHandler handler, boolean isRegulated) {
        int accepts = filter.matches(fluidStack, handler, isRegulated);
        if (whitelist && filter.isEmpty()) {
            return false;
        }
        return filter.isEmpty() != (whitelist == accepts > 0);
    }

    @Override
    public void updateClient() {
        super.updateClient();
        for (Direction value : Direction.values()) {
            while (this.queue.computeIfAbsent(value, direction -> new ArrayList()).size() < 6) {
                this.queue.get(value).add(0, FluidStack.EMPTY);
            }
            this.queue.get(value).add(0, FluidStack.EMPTY);
            while (this.queue.get(value).size() > 6) {
                this.queue.get(value).remove(this.queue.get(value).size() - 1);
            }
        }
    }

    public void addTransferedStack(Direction direction, FluidStack stack) {
        this.syncRender(direction, stack.writeToNBT(new CompoundTag()));
    }

    @Override
    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
        this.queue.computeIfAbsent(origin, direction -> new ArrayList()).add(0, FluidStack.loadFluidStackFromNBT((CompoundTag)compoundNBT));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, PoseStack stack, int combinedOverlayIn, MultiBufferSource buffer, float frame) {
        super.renderTransfer(pos, direction, step, stack, combinedOverlayIn, buffer, frame);
        if (step < this.queue.computeIfAbsent(direction, v -> new ArrayList()).size()) {
            float scale = 0.1f;
            stack.m_85841_(scale, scale, scale);
            FluidStack fluidStack = this.queue.get(direction).get(step);
            stack.m_85836_();
            stack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
            stack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            stack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            VertexConsumer buffer1 = buffer.m_6299_(TransporterTESR.TYPE);
            Matrix4f matrix = stack.m_85850_().m_85861_();
            float pX1 = 1.0f;
            float u = 1.0f;
            float pX2 = 0.0f;
            float u2 = 0.0f;
            float xOffset = -0.75f;
            float yOffset = -0.0f;
            float zOffset = -0.75f;
            boolean alpha = true;
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            if (fluidStack.isEmpty()) {
                Color CLOSE = Color.CYAN;
                Color FAR = new Color(6815999);
                double ratio = ((double)step + 2.5) / 6.0;
                red = (float)((int)Math.abs(ratio * (double)FAR.getRed() + (1.0 - ratio) * (double)CLOSE.getRed())) / 256.0f;
                green = (float)((int)Math.abs(ratio * (double)FAR.getGreen() + (1.0 - ratio) * (double)CLOSE.getGreen())) / 256.0f;
                blue = (float)((int)Math.abs(ratio * (double)FAR.getBlue() + (1.0 - ratio) * (double)CLOSE.getBlue())) / 256.0f;
                stack.m_85841_(0.25f, 0.25f, 0.25f);
            } else {
                Color color = new Color(FluidUtils.getFluidColor(fluidStack));
                red = (float)color.getRed() / 256.0f;
                green = (float)color.getGreen() / 256.0f;
                blue = (float)color.getBlue() / 256.0f;
                stack.m_85841_(0.75f, 0.75f, 0.75f);
            }
            buffer1.m_85982_(matrix, pX2 + xOffset, yOffset, 0.0f + zOffset).m_85950_(red, green, blue, (float)alpha).m_7421_(u2, 0.0f).m_5752_();
            buffer1.m_85982_(matrix, pX1 + xOffset + 0.5f, yOffset, 0.0f + zOffset).m_85950_(red, green, blue, (float)alpha).m_7421_(u, 0.0f).m_5752_();
            buffer1.m_85982_(matrix, pX1 + xOffset + 0.5f, yOffset, 1.5f + zOffset).m_85950_(red, green, blue, (float)alpha).m_7421_(u, 1.0f).m_5752_();
            buffer1.m_85982_(matrix, pX2 + xOffset, yOffset, 1.5f + zOffset).m_85950_(red, green, blue, (float)alpha).m_7421_(u2, 1.0f).m_5752_();
            stack.m_85849_();
        }
    }

    public static class Factory
    extends TransporterTypeFactory {
        public Factory() {
            this.setRegistryName("fluid");
        }

        @Override
        public TransporterType create(IBlockContainer container, Direction face, TransporterTypeFactory.TransporterAction action) {
            return new TransporterFluidType(container, this, face, action);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, TransporterTypeFactory.TransporterAction action) {
            return new ResourceLocation("industrialforegoing", "block/transporters/fluid_transporter_" + action.name().toLowerCase() + "_" + upgradeSide.m_7912_().toLowerCase());
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("industrialforegoing:blocks/transporters/fluid"), new ResourceLocation("industrialforegoing:blocks/base/bottom")});
        }

        @Override
        public boolean canBeAttachedAgainst(Level world, BlockPos pos, Direction face) {
            return TileUtil.getTileEntity((BlockGetter)world, (BlockPos)pos).map(tileEntity -> tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).isPresent()).orElse(false);
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "block/transporters/fluid_transporter_" + TransporterTypeFactory.TransporterAction.EXTRACT.name().toLowerCase() + "_" + Direction.NORTH.m_7912_().toLowerCase());
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem(), (int)2).m_126130_("IPI").m_126130_("GMG").m_126130_("ICI").m_206416_(Character.valueOf('I'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42584_).m_206416_(Character.valueOf('G'), Tags.Items.GEMS_LAPIS).m_206416_(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41869_).m_176498_(consumer);
        }
    }
}

